<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element;
use Zend\Form\Element\Select;
use Zend\Form\Element\Text;
use Zend\Form\Element\Submit;
use Zend\Form\Element\Email;

class BookingDriverSearchForm extends Form {

    public static $driverrating =[];
    public function __construct($name = null) {

        parent::__construct('booking-driver-search-form');
        $this->setAttribute('method', 'post');

        /**
         * Driver Tab start
         * Driver First Name
         */
        $this->add([
            'name' => 'driver_first_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'driver-first-name',
                'placeholder' => 'Driver first Name',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Driver First Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Driver Last Name
         */
        $this->add([
            'name' => 'driver_last_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'driver-last-name',
                'placeholder' => 'Driver last Name',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Driver Last Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Driver ID
         */
        $this->add([
            'name' => 'driver_id',
            'type' => Text::class,
            'attributes' => [
                'id' => 'driver-id',
                'placeholder' => 'Driver Id',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Driver Id<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * External Reference
         */
        $this->add([
            'name' => 'referral_key',
            'type' => Text::class,
            'attributes' => [
                'id' => 'referral-key',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'External Reference<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],

        ]);

        /**
         * Driver Rating
         */
        $this->add([
            'name' => 'driver_rating',
            'type' => Select::class,
            'attributes' => [
                'id' => 'driver-rating',
                'class' => 'col-sm-12 col-lg-12 inputfild name valid form-control'
            ],
            'options' => [
                'label' => 'Driver Rating<span style="color: red"> *</span>',
                'value_options' => self::$driverrating,
            ],
        ]);

        /**
         *
         * Driver Email
         */
        $this->add([
            'name' => 'driver_email',
            'type' => Email::class,
            'attributes' => [
                'id' => 'driver-email',
                'placeholder' => 'Driver Email',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Driver Email<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Driver Tab end
         * Driver mobile No
         */
        $this->add([
            'name' => 'driver_mobile_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'driver-mobile-no',
                'placeholder' => 'Driver mobile No',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Driver mobile No<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Search
         */
        $this->add([
            'name' => 'search',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Search',
                'id' => 'search',
                'class' => 'btn btn-primary btn-lg booking-his'
            ],
        ]);

        /**
         * Clear
         */
        $this->add([
            'name' => 'clear',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Clear',
                'id' => 'clear',
                'class' => 'btn btn-primary btn-lg'
            ],
        ]);
    }

}
