<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element;
use Zend\Form\Element\Select;
use Zend\Form\Element\Text;
use Zend\Form\Element\Email;
use Zend\Form\Element\Submit;

class BookingClientSearchForm extends Form {
    public static $clientrating=[];

    public function __construct($name = null) {

        //echo "niharikaform";die;
        parent::__construct('booking-client-search-form');
        $this->setAttribute('method', 'post');

        /**
         * Client Tab start
         * Client First Name
         */
        $this->add([
            'name' => 'client_first_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'client-first-name',
                'placeholder' => 'Client first Name',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Client First Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Client Last Name
         */
        $this->add([
            'name' => 'client_last_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'client-last-name',
                'placeholder' => 'Client last Name',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Client Last Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Client ID
         */
        $this->add([
            'name' => 'client_id',
            'type' => Text::class,
            'attributes' => [
                'id' => 'client-id',
                'placeholder' => 'Client Id',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Client Id<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Client Rating
         */
        $this->add([
            'name' => 'client_rating',
           'type' => Select::class,
            'attributes' => [
                'id' => 'client-rating',
                'class' => 'col-sm-12 col-lg-12 inputfild name valid form-control'
            ],
            'options' => [
                'label' => 'Client Rating<span style="color: red"> *</span>',
                'value_options' => self::$clientrating,
            ],

        ]);

        /**
         * Mobile No.
         */
        $this->add([
            'name' => 'client_mobile_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'cleint-mobile-no',
                'placeholder' => 'Mobile No',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Mobile No<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Client Tab end
         * Client Email
         */
        $this->add([
            'name' => 'client_email',
            'type' =>Email::class,
            'attributes' => [
                'id' => 'client-email',
                'placeholder' => 'Client Email',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Client Email<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Search
         */
        $this->add([
            'name' => 'search',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Search',
                'id' => 'search',
                'class' => 'btn btn-primary btn-lg booking-his'
            ],
        ]);

        /**
         * Clear
         */
        $this->add([
            'name' => 'clear',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Clear',
                'id' => 'clear',
                'class' => 'btn btn-primary btn-lg'
            ],
        ]);
    }

}
