<?php

namespace Dashboard\Controller;

use Application\Controller\RestAPIClientController;
use Zend\View\Model\{
    ViewModel,
    JsonModel
};
use Zend\Json\Json;
use Zend\Session\Container;
use Dashboard\Form\{
    VehicleAmenitiesForm
};
use Zend\Debug\Debug;
use Dashboard\Model\Vehicle;

class VehicleAmenitiesController extends RestAPIClientController {

    public function __construct() {
        $this->vehicleModel = new Vehicle();
    }

    /**
     * Index
     * @return ViewModel
     */
    public function indexAction() {
        $data = "";
        $status = "";
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        VehicleAmenitiesForm::$amenitiestype = $this->vehicleModel->getVehicleAmenitiesList();
        $form = new VehicleAmenitiesForm();
        $request = $this->getRequest();
        if ($request->isPost()) {
            $post = $request->getPost()->toArray();
            $status = (isset($post['status'])) ? $post['status'] : '';
            //Debug::dump($post); exit;
            $form->setData($request->getPost());
            if (!empty($post['search_vehicle_amenities'])) {
                if ($post['vehicle_amenities_type'] != "" && $post['status'] == "") {
                    $val = '{"where": {"id":' . $post['vehicle_amenities_type'] . '}}';
                    $data = rawurlencode($val);
                } else if ($post['vehicle_amenities_type'] != "" && $post['status'] != "") {
                    $val = '{"where":{"and": [{"id": "' . $post['vehicle_amenities_type'] . '"},{"status":' . $post['status'] . '}]}}';
                    $data = rawurlencode($val);
                } else if ($post['vehicle_amenities_type'] == "" && $post['status'] != "") {
                    $val = '{"where": {"status":' . $post['status'] . '}}';
                    $data = rawurlencode($val);
                }
            } else {
                $created_date = date('Y-m-d H:i:s');
                $data = [];
                $data = [
                    'amenities_name' => $post['vehicle_amenities_name'],
                    'status' => $post['status'],
                    'created_date' => $created_date,
                    'created_by' => $user_id
                ];
                $insertStatus = $this->vehicleModel->insertVehicleAmenitiesType($data);
                $data = "";
            }
        }

        $mvehicleList = $this->vehicleModel->getVehicleAmenitiesData($data);
        $mvehicleList = $mvehicleList['data'];
        $viewModel = new ViewModel(['form' => $form, 'mvehicleList' => $mvehicleList, 'vehicle_type_id' => '', 'status' => $status]);
        return $viewModel;
    }

    public function deleteAction() {
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id];
        $this->vehicleModel->deleteVehicleAmenities($data);
        $this->redirect()->toRoute('vehicleamenities', ['action' => 'index']);
    }

    public function editAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $form = new VehicleAmenitiesForm();
        $id = $this->params()->fromQuery('id');
        $url = $this->apiUrl() . "/vehicle-amenities/" . $id;
        $resp = $this->get($url);
        $vehicleData = Json::decode($resp->getBody(), true);
        //Debug::dump($vehicleData); exit;
        $vehicleType = $vehicleData['amenities_name'];
        $vehicleTypeStatus = $vehicleData['status'];
        $form->get('vehicle_amenities_name')->setValue($vehicleType);
        $form->get('vehicle_amenities_id')->setValue($id);
        $request = $this->getRequest();
        if ($request->isPost()) {
            $post = $request->getPost()->toArray();
            //echo '<pre>';print_r($post);die();
            $data = [];
            $data = ['id' => $post['vehicle_amenities_id'], 'amenities_name' => $post['vehicle_amenities_name'], 'status' => $post['status'], 'modified_by' => $user_id];
            $insertStatus = $this->vehicleModel->updateVehicleAmenitiesType($data);
            $this->redirect()->toRoute('vehicleamenities', ['action' => 'index']);
        }
        $mvehicleList = $this->vehicleModel->getVehicleAmenitiesData();
        $mvehicleList = $mvehicleList['data'];
        $viewModel = new ViewModel(['form' => $form, 'mvehicleList' => $mvehicleList, 'vehicle_type_id' => $id, 'status' => $vehicleTypeStatus]);
        $viewModel->setTemplate('/dashboard/vehicle-amenities/edit-vehicle-amenities');
        return $viewModel;
    }

    /** Function to change VEHICLE AMENITIES STATUS */
    public function vehicleAmenitiesStatusAction() {
        $data1 = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $data = $this->getRequest()->getPost();
        //print_r($data); die;
        $id = implode(',', $data['selected']);
        $vehicle_amenities_status = $data['status'];
        $data1 = ['id' => $id, 'user_id' => $user_id, 'vehicle_amenities_status' => $vehicle_amenities_status];
        //echo '<pre>';print_r($data1);die();
        $this->vehicleModel->updateVehicleAmenitiesStatus($data1);
        $mvehicleList = $this->vehicleModel->getVehicleAmenitiesData();
        $mvehicleList = $mvehicleList['data'];
        //echo '<pre>';print_r($mvehicleList);die();
        $viewModel = new ViewModel(['mvehicleList' => $mvehicleList]);
        $viewModel->setTemplate('/dashboard/vehicle-amenities/vehicle-amenities-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }

}
