<?php

namespace Dashboard\Controller;

use Zend\Mvc\Controller\AbstractActionController;
use Zend\View\Model\ViewModel;
use Dashboard\Form\PackageAddForm;
use Dashboard\Form\PackageSearchForm;
use Dashboard\Form\TourInclusionAddForm;

class TourPackageController extends AbstractActionController {

    
    /**
     * Index
     * @return ViewModel
     */
    public function indexAction(){
          $form= new PackageAddForm();
          
       
            
        //Call API...
        $packageListing = [
            '0'=>[
                'name'=>'Las Vegas',
                'price'=>'300',
                'vendor_price'=>'333',
                'discount_price'=>'120',
                'child_price'=>'100',
                'child_discount'=>'30',
                'infant_price'=>'60',
                'infant_discount'=>'67.9',
                'start_date'=>'02-06-2018',
                'end_date'=>'25-8-2018'
            ],
            '1'=>[
                'name'=>'New York',
                'price'=>'300',
                'vendor_price'=>'303',
                'discount_price'=>'85',
                'child_price'=>'43',
                'child_discount'=>'43',
                'infant_price'=>'45',
                'infant_discount'=>'67.9',
                'start_date'=>'02-06-2018',
                'end_date'=>'25-8-2018'
            ],
            '2'=>[
                'name'=>'Montana Hill',
                'price'=>'300',
                'vendor_price'=>'303',
                'discount_price'=>'45',
                'child_price'=>'34',
                'child_discount'=>'34',
                'infant_price'=>'54',
                'infant_discount'=>'67.9',
                'start_date'=>'02-06-2018',
                'end_date'=>'25-8-2018'
            ]            
        ];
      
        $viewModel = new ViewModel(['packageListing'=>$packageListing,
            'form'=>$form]);
        return $viewModel;
    }
    
    public function addTourPackageAction(){
        
        $form= new PackageAddForm();
        
         $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray();

                return $this->redirect()->toRoute('tour-package', ['action' => 'add-tour-package']);
            }
        }
          
        $viewModel = new ViewModel(['form'=>$form]);
        return $viewModel;
        
    }
     
    public function packageDealAction(){
         $form= new PackageAddForm();
    
       
        $viewModel = new ViewModel( ['form'=>$form]);
        return $viewModel;
        // $this->FormElement($form->get('tax_included'));
    }
    
     public function tourPackageListingAction(){
        $viewModel = new ViewModel();
        return $viewModel;
        
    }
    
    public function editTourPackageAction(){
        
        $form= new PackageAddForm();
        $viewModel = new ViewModel( ['form'=>$form]);
        return $viewModel;
        
    }
    
    // --------------packeges------------
    public function generalInformationAction(){
        
        $form= new PackageAddForm();
        $viewModel = new ViewModel( ['form'=>$form]);
        return $viewModel;
        
    }
    
     public function featureInformationAction(){
         
        $form= new PackageAddForm;  
      $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray();

                return $this->redirect()->toRoute('tour-package', ['action' => 'feature-information']);
            }    
        }
         
         
       
        $viewModel = new ViewModel( ['form'=>$form]);
        return $viewModel;
        
    }
    
     public function pricePaymentInformationAction(){
        
        $form= new PackageAddForm();
        
         $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray();

                return $this->redirect()->toRoute('tour-package', ['action' => 'feature-information']);
            }    
        }
        
        $viewModel = new ViewModel( ['form'=>$form]);
        return $viewModel;
        
    }
     public function pictureMetaInformationAction(){
        
        $form= new PackageAddForm();
        
         $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray();

                return $this->redirect()->toRoute('tour-package', ['action' => 'picture-meta-information']);
            }    
        }
        $viewModel = new ViewModel( ['form'=>$form]);
        return $viewModel;
        
    }
    public function tourInclusionsAction(){
        
        $form1= new PackageAddForm();
        $form= new TourInclusionAddForm();
        
         $request = $this->getRequest();
                      
        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray();

                return $this->redirect()->toRoute('tour-package', ['action' => 'tour-availability-others']);
            }    
        }
        
        $viewModel = new ViewModel(['form1'=>$form1,'form'=>$form]);
        return $viewModel;
        
        
        
    }
     public function tourAvailabilityOthersAction(){
         $form= new PackageAddForm();
         
         $request = $this->getRequest();
                      
        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray();

                return $this->redirect()->toRoute('tour-package', ['action' => 'tour-availability-others']);
            }    
        }
         
       
        $viewModel = new ViewModel( ['form'=>$form]);
        return $viewModel;
        
    }
    
     public function pricePaymentInformation2Action(){
        
        $form= new PackageAddForm();
        
         $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray();

                return $this->redirect()->toRoute('tour-package', ['action' => 'feature-information']);
            }    
        }
        
        $viewModel = new ViewModel( ['form'=>$form]);
        return $viewModel;
        
    }
 
}
