<?php

namespace Dashboard;

use Zend\Router\Http\Segment;
use Zend\ServiceManager\Factory\InvokableFactory;

return [
    'router' => [
        'routes' => [
            'dashboard' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/dashboard[/:action]',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],
            'bid' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/bid[/:action[/:id]]',
                    'defaults' => [
                        'controller' => Controller\BidController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],
            'tour-package' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/tour-package[/:action[/:id]]',
                    'defaults' => [
                        'controller' => Controller\TourPackageController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],
            'tour-type' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/tour-type[/:action[/:id]]',
                    'defaults' => [
                        'controller' => Controller\TourTypeController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],
            'tour-inclusion' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/tour-inclusion[/:action[/:id]]',
                    'defaults' => [
                        'controller' => Controller\TourInclusionController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],
            'tour-exclusion' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/tour-exclusion[/:action[/:id]]',
                    'defaults' => [
                        'controller' => Controller\TourExclusionController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],
            'manage-payment-structure' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/manage-payment-structure[/:action[/:id]]',
                    'defaults' => [
                        'controller' => Controller\ManagePaymentStructureController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],
            'manage-documentation' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/manage-documentation[/:action[/:id]]',
                    'defaults' => [
                        'controller' => Controller\ManageDocumentationController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],
            'cancellation-policy' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/cancellation-policy[/:action[/:id]]',
                    'defaults' => [
                        'controller' => Controller\CancellationPolicyController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],
            'manage-refund-policy' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/manage-refund-policy[/:action[/:id]]',
                    'defaults' => [
                        'controller' => Controller\ManageRefundPolicyController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],
            'manage-term-conditions' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/manage-term-conditions[/:action[/:id]]',
                    'defaults' => [
                        'controller' => Controller\ManageTermConditionsController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],
             'manage-transfer-master' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/manage-transfer-master[/:action[/:id]]',
                    'defaults' => [
                        'controller' => Controller\ManageTransferMasterController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],
             'manage-city-instruction-master' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/manage-city-instruction-master[/:action[/:id]]',
                    'defaults' => [
                        'controller' => Controller\MasterModuleController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],
            'master-module' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/master-module[/:action[/:id]]',
                    'defaults' => [
                        'controller' => Controller\MasterModuleController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],
            'page-management' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/page-management[/:action[/:id]]',
                    'defaults' => [
                        'controller' => Controller\PageManagementController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],
            'menu' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/menu[/:action[/:id]]',
                    'defaults' => [
                        'controller' => Controller\MenuController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                        'id' => '[a-z-]+'
                    ],
                ],
            ],
            'billingmanagement' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/billingmanagement[/:action]',
                    'defaults' => [
                        'controller' => Controller\BillingManagementController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],
            'markup' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/markup[/:action[/:type]]',
                    'defaults' => [
                        'controller' => Controller\MarkupController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                        'type' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                ],
            ],
            'bookinghistory' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/bookinghistory[/:action]',
                    'defaults' => [
                        'controller' => Controller\BookingHistoryController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],
            'cancellationdeadline' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/cancellationdeadline[/:action]',
                    'defaults' => [
                        'controller' => Controller\CancellationDeadlineController::class,
                        'action' => 'cancellationHome',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],
            'companyprice' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/companyprice[/:action][/:id]',
                    'defaults' => [
                        'controller' => Controller\CompanyPriceController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                        'id' => '[0-9_-]*',
                    ],
                ],
            ],
            'cabfare' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/cabfare[/:action][/:id]',
                    'defaults' => [
                        'controller' => Controller\CabFareController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                        'id' => '[0-9_-]*',
                    ],
                ],
            ],
            'guidefare' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/guidefare[/:action]',
                    'defaults' => [
                        'controller' => Controller\GuideFareController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],
            'payment' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/payment[/:action]',
                    'defaults' => [
                        'controller' => Controller\PaymentController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],

            'statementofaccount' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/statementofaccount[/:action]',
                    'defaults' => [
                        'controller' => Controller\StatementOfAccountController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],
            'usermanagement' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/usermanagement[/:action][/:id]',
                    'defaults' => [
                        'controller' => Controller\UserManagementController::class,
                        'action' => 'index',
                        'id' => '[0-9]*',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],
            'drivermanagement' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/drivermanagement[/:action][/:id]',
                    'defaults' => [
                        'controller' => Controller\DriverManagementController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],
            'vehicle-details' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/vehicle-details[/:action][/:id]',
                    'defaults' => [
                        'controller' => Controller\VehicleDetailsController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],
            'profile' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/profile[/:action]',
                    'defaults' => [
                        'controller' => Controller\ProfileController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],
            'templatesettings' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/templatesettings[/:action]',
                    'defaults' => [
                        'controller' => Controller\TemplateSettingsController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],

            'theme-management' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/theme-management[/:action]',
                    'defaults' => [
                        'controller' => Controller\ThemeManagementController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],
            'global-settings' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/global-settings[/:action]',
                    'defaults' => [
                        'controller' => Controller\GlobalSettingsController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],
            'userrolemanager' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/role-management[/:action]',
                    'defaults' => [
                        'controller' => Controller\UserRoleManagerController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],
            'membership-package' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/membership-package[/:action]',
                    'defaults' => [
                        'controller' => Controller\MemberShipPackageController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],




            'vehicletype' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/vehicletype[/:action]',
                    'defaults' => [
                        'controller' => Controller\VehicleTypeController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],

            'airport-master' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/airport-master[/:action]',
                    'defaults' => [
                        'controller' => Controller\AirportMasterController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],
            'vehiclename' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/vehiclename[/:action]',
                    'defaults' => [
                        'controller' => Controller\VehicleNameController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],

            'vehicleamenities' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/vehicleamenities[/:action]',
                    'defaults' => [
                        'controller' => Controller\VehicleAmenitiesController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],

            'credit' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/credit[/:action]',
                    'defaults' => [
                        'controller' => Controller\CreditController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],
            'staff' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/staff[/:action]',
                    'defaults' => [
                        'controller' => Controller\StaffController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],
            'setting' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/setting[/:action]',
                    'defaults' => [
                        'controller' => Controller\SettingController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],

        ],
    ],
    'controllers' => [
        'factories' => [
            Controller\IndexController::class => InvokableFactory::class,
            Controller\BidController::class => InvokableFactory::class,
            Controller\TourPackageController::class => InvokableFactory::class,
            Controller\TourTypeController::class => InvokableFactory::class,
            Controller\TourInclusionController::class=> InvokableFactory::class,
            Controller\TourExclusionController::class=> InvokableFactory::class,
            Controller\ManagePaymentStructureController::class=> InvokableFactory::class,
            Controller\ManageDocumentationController::class=> InvokableFactory::class,
            Controller\CancellationPolicyController::class=> InvokableFactory::class,
            Controller\ManageRefundPolicyController::class=> InvokableFactory::class,
            Controller\ManageTermConditionsController::class=> InvokableFactory::class,
            Controller\ManageTransferMasterController::class=> InvokableFactory::class,
            Controller\ManageCityInstructionMasterController::class=> InvokableFactory::class,
            Controller\MasterModuleController::class=> InvokableFactory::class,
            Controller\PageManagementController::class=> InvokableFactory::class,
            Controller\MenuController::class=> InvokableFactory::class,
            Controller\BillingManagementController::class => InvokableFactory::class,
            Controller\CreditController::class => InvokableFactory::class,
            Controller\MarkupController::class => InvokableFactory::class,
            Controller\BookingHistoryController::class => InvokableFactory::class,
            Controller\CancellationDeadlineController::class => InvokableFactory::class,
            Controller\CompanyPriceController::class => InvokableFactory::class,
            Controller\PaymentController::class => InvokableFactory::class,
            Controller\StatementOfAccountController::class => InvokableFactory::class,
            Controller\UserManagementController::class => InvokableFactory::class,
            Controller\VehicleDetailsController::class => InvokableFactory::class,
            Controller\ProfileController::class => InvokableFactory::class,
            Controller\TemplateSettingsController::class => InvokableFactory::class,
            Controller\ThemeManagementController::class => InvokableFactory::class,
            Controller\GlobalSettingsController::class => InvokableFactory::class,
            Controller\UserRoleManagerController::class => InvokableFactory::class,
            Controller\GuideFareController::class => InvokableFactory::class,
            Controller\CabFareController::class => InvokableFactory::class,
            Controller\MemberShipPackageController::class => InvokableFactory::class,
            Controller\VehicleTypeController::class => InvokableFactory::class,
            Controller\AirportMasterController::class => InvokableFactory::class,
            Controller\VehicleNameController::class => InvokableFactory::class,
            Controller\DriverManagementController::class => InvokableFactory::class,
            Controller\VehicleAmenitiesController::class => InvokableFactory::class,
            Controller\StaffController::class => InvokableFactory::class,
        ],
    ],
    'view_manager' => [
        'display_not_found_reason' => true,
        'display_exceptions' => true,
        'doctype' => 'HTML5',
        'not_found_template' => 'error/404',
        'exception_template' => 'error/index',
        'template_map' => [
            'layout/layout' => __DIR__ . '/../view/layout/layout.phtml',
            'dashboard/index/index' => __DIR__ . '/../view/dashboard/index/index.phtml',
            'error/404' => __DIR__ . '/../view/error/404.phtml',
            'error/index' => __DIR__ . '/../view/error/index.phtml',
        ],
        'template_path_stack' => [
            __DIR__ . '/../view',
        ],
        'strategies' => [
            'ViewJsonStrategy',
        ],
    ],
    'moduleLayouts' => [
        'Dashboard' => 'layout/dashboard.phtml'
    ],
     'view_helpers' => [
        'factories' => [
            View\Helper\DashboardMenu::class => InvokableFactory::class
        ],
        'aliases' => [
            'dashboardMenu' => View\Helper\DashboardMenu::class
        ],
    ],
];
