<?php

namespace Application\View\Helper;

use Zend\View\Helper\AbstractHelper;
use Application\Controller\RestAPIClientController;
use Zend\Json\Json;

class MyHelper extends AbstractHelper {

    public function test($messages) {
        echo $messages;
    }

    public function getMenu($group_name) {
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $val = [
            'comp_id' => $config->company->companyId,
            'url' => $config->api->url,
            'group_name' => $group_name
        ];
        $data = $this->fetchMenu($val);
        return $data;
    }

    public function fetchMenu($val) {
        $api = new RestAPIClientController();
        $data = ['company_setup_id' => $val['comp_id'], 'group_name' => $val['group_name']];
        $url = $val['url'] . '/cms-pages/getCmsPages';
        $resp = $api->post($url, $data);
        $menuData = Json::decode($resp->getBody(), true);
        return $menuData;
    }

    public function getCompanyData() {
        $api = new RestAPIClientController();
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $url = $config->api->url . "/company-setup/" . $config->company->companyId;
        $resp = $api->get($url);
        $compJsonData = Json::decode($resp->getBody(), true);
        return $compJsonData;
    }

    public function getSeoData($city_id,$master_package_id) {
        $seoData =[];
        $api = new RestAPIClientController();
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $data = [
            'booking_type'=>$master_package_id,
            'city_id'=>$city_id,
            'company_setup_id'=>$config->company->companyId,
        ];
        $url = $config->api->url . "/city-pages/getcityPages";
        $resp = $api->post($url,$data);
        $packageFareData = Json::decode($resp->getBody(), true);
        if (!empty($packageFareData)) {
            if ($packageFareData['responsedata']['status'] == "success") {
                $seoData = $packageFareData['responsedata']['data'];
            }
        }
        return $seoData;
    }

    public function fetchTestimonials() {
        $api = new RestAPIClientController();
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $url = $config->api->url . "/testimonial/gettestimonial?company_id=".$config->company->companyId;
        $resp = $api->get($url);
        $data = Json::decode($resp->getBody(), true);
        return $data['responsedata'];
    }


    public function getJobsDataByDepId($dep_id) {
        $api = new RestAPIClientController();
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $val = '{"where": {"dep_id": "' . $dep_id . '"}}';
        $val = rawurlencode($val);
        $url = $config->api->url . "/department-jobs?&filter=" . $val;
        $resp = $api->get($url);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }

    public function fetchDeptName($dep_id) {
        $api = new RestAPIClientController();
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $val = '{"where": {"id": "' . $dep_id . '"}}';
        $val = rawurlencode($val);
        $url = $config->api->url . "/department?&filter=" . $val;
        $resp = $api->get($url);
        $val = Json::decode($resp->getBody(), true);
        $data = isset($val[0]) ? $val[0] : 0;
        if ($data != "") {
            $val = $data['department_name'];
        } else {
            $val = "NA";
        }
        return $val;
    }
     public function getRelationalData($user_id) {
        $api = new RestAPIClientController();
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $url = $config->api->url . "/user-management/userRelationManager?id=". $user_id;
        $val =  $api->get($url);
        $Data = $val->getBody();
        $JsonData = Json::decode($Data, true);
        return $JsonData;
    }

    public function getWalletAmt($user_id) {
        $api = new RestAPIClientController();
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $url = $config->api->url . "/user/walletamount?user_id=" . $user_id;
        $resp = $api->get($url);
        $response = Json::decode($resp->getBody(), true);
        $walletAmt = $response['responsedata']['data']['credit_balance'];
        if ($walletAmt != "") {
            $data = $response['responsedata']['data']['credit_balance'];
        } else {
            $data = 0;
        }
        return $data;
    }

	public function getCreditAmtBalance($user_id) {
        $data = 0;
        $api = new RestAPIClientController();
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $url = $config->api->url . "/user/userUploadCreditBalance?user_id=" . $user_id;
        $resp = $api->get($url);
        $response = Json::decode($resp->getBody(), true);
        if($response['responsedata']['status']=='success'){
            $walletAmt = $response['responsedata']['data']['balance'];
            if ($walletAmt != "") {
                $data = $response['responsedata']['data']['balance'];
            }
        }
        return $data;
    }

    /*public function getSightSeeingAmount($data,$searchData) {
        echo '<pre>';print_r($data);//die();
        $val = [];
        if (!empty($data)) {
            $fareData = Json::decode($data, true);
            echo '<pre>';print_r($fareData);die();
            $adultFare = $fareData[0]['adult_price'];
            $childFare = $fareData[0]['child_price'];
            $totalFare = ($adultFare * $searchData['adults']) + ($childFare * $searchData['childs']);
        } else {
            $adultFare = 0;
            $childFare = 0;
            $totalFare = $adultFare + $childFare;
        }

        $val = [
            'adultFare'=>$adultFare,
            'childFare'=>$childFare,
            'totalFare'=>$totalFare,
        ];
    }*/

    public function getUserPendingDoc($user_id) {
        $api = new RestAPIClientController();
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $url = $config->api->url . "/user/getuserpendingdoc?user_id=".$user_id;
        $resp = $api->get($url);
        $data = Json::decode($resp->getBody(), true);
        if($data['responsedata']['status']=="success"){
            $val = $data['responsedata']['data'];
        }
        return $val;
    }

    public function getRecentlyViewedItems($data) {
        $val =[];
        $api = new RestAPIClientController();
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $url = $config->api->url . "/recently-viewed/getrecentvieweditems";
        $resp = $api->post($url,$data);
        $data = Json::decode($resp->getBody(), true);
        if($data['responsedata']['status']=="success"){
            $val = $data['responsedata']['data'];
        }
        return $val;
    }

    public function getCityName($id) {
        $api = new RestAPIClientController();
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $val = '{"where": {"id": "' . $id . '"}}';
        $val = rawurlencode($val);
        $url = $config->api->url . "/city?&filter=" . $val;
        $resp = $api->get($url);
        $data = Json::decode($resp->getBody(), true);
        return $data[0];
    }

    public function getServiceModuleByCity($city_id) {
        $moduleData = [];
        if($city_id!=""){
        $api = new RestAPIClientController();
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $url = $config->api->url . "/city_active_package/city?cityId=" . $city_id;
        $resp = $api->get($url);
        $moduleJsonData = Json::decode($resp->getBody(), true);
        if (!empty($moduleJsonData['responsedata'])) {
            foreach ($moduleJsonData['responsedata'] as $value) {
                $moduleData[] = ["module_name" => $value['name'], "module_icon" => $value['icon'], "city_name" => $value['city_name'], "city_id" => $value['city_id']];
            }
        }
        }
        return $moduleData;
    }

    public function getSightseeingDetailsByCity($city_id) {
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $sightData = [];
        if($city_id!=""){
                $data= [
                    'city_id'=>$city_id,
                ];
        }
        $data['master_package_type']=$config->masterPackage->activity;
        $data['master_booking_type']=$config->masterBookType->attractions;
        $api = new RestAPIClientController();
        $url = $config->api->url . "/sightseeing/listsightseeing";        
        $resp = $api->post($url, $data);
        $packageFareData = Json::decode($resp->getBody(), true);
        if (!empty($packageFareData)) {
            if ($packageFareData['responsedata']['status'] == "success") {
                $sightData = $packageFareData['responsedata']['data'];
            }
        }

        return $sightData;
    }

    public function getWishListData($user_id) {
        $seoData =[];
        $api = new RestAPIClientController();
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $data = [
            'user_id'=>$user_id
        ];
        $url = $config->api->url . "/sightseeing/getwishList";
        $resp = $api->post($url,$data);
        $packageFareData = Json::decode($resp->getBody(), true);
        if (!empty($packageFareData)) {
            if ($packageFareData['responsedata']['status'] == "success") {
                $seoData = $packageFareData['responsedata']['data'];
            }
        }
        return $seoData;
    }
    
    /* Added By MOHIT VERMA
     * NEED TO BE CHECKED
     */

    public function getNotificationList($userId) {
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $apiUrl = $config->api->url;
        $api = new RestAPIClientController();
        if($userId > 0){
            $url = $apiUrl . '/notification/notificationList?driver_id='.$userId;
            $resp = $api->get($url);
            $notificationData = Json::decode($resp->getBody(), true);

            if (isset($notificationData) && ($notificationData['responsedata']['status']=='success')) {
                 return $notificationData['responsedata']['data'];
            }
        }else{
            return $notificationData = [];
        }
    }
    
    public function fetchBookingModule($id) {
         $api = new RestAPIClientController();
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $val = '{"where": {"id": "' . $id . '"}}';
        $val = rawurlencode($val);
        $url = $config->api->url . "/master-booking-type?&filter=" . $val;
        $resp = $api->get($url);
        $data = Json::decode($resp->getBody(), true);
        if ($data!= "") {
            $val = isset($data['data'][0]['booking_type']) ? $data['data'][0]['booking_type']:'NA';
        } else {
            $val = "NA";
        }
        return $val;
    }

}