<?php

/** @CreatedBy : Mohit Jain
 *  @Description : Common Model Functions
 */

namespace Application\Model;

use Application\Controller\RestAPIClientController;
use Zend\Session\Container;
use Zend\Json\Json;

class CommonModel extends RestAPIClientController {

    public function apiUrl() {
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        return $config->api->url;
    }

    /** @CreatedBy : Mohit Jain
    *   @Description : Get Lowest One Way Fare List
     *
    */
    public function getLowestOneWayFareList($paramdata){
        $data = [];
        $url = $this->apiUrl() . "/bidding/lowestonewayfare";
        $resp = $this->post($url,$paramdata);
        $oneWayData = Json::decode($resp->getBody(), true);
        if($oneWayData['responsedata']['status']=="success"){
            $data = $oneWayData['responsedata']['data'];
        }
        return $data;
    }

    public function getCmsPageData($pageType,$id) {
        $val = '{"where":{"and": [{"company_setup_id": "' . $id . '"},{"page_type": "' . $pageType . '"}]}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/cms-pages/?filter=" . $val;
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }

    public function getReferralAmt() {
        $val = '{"where": {"user_type":1}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/referral-discount-amount?filter=" . $val;
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }

    public function getOffers($id) {
        $val = '{"where": {"company_id":"' . $id . '"}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/coupon-list?filter=" . $val;
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }

    public function getAllDepartmentList() {
        $getdata = '{"where":{"status": {"neq": 2}}}';
        $getdata = rawurlencode($getdata);
        $url = $this->apiUrl() . "/department?&filter=" . $getdata;
        $val = $this->get($url);
        $JsonData = $val->getBody();
        $JsonData = Json::decode($JsonData, true);
        return $JsonData;
    }

    public function getCityDistance($from_city, $to_city) {
        $data = 0;
        $url = $this->apiUrl() . "/city-distance-list/citykilometer?sourcecity=" . $from_city . "&destinationcity=" . $to_city;
        $resp = $this->get($url);
        $cityData = Json::decode($resp->getBody(), true);
        if ($cityData['status'] == 'success') {
            $cityJsonData = $cityData['data'];
            $data = $cityJsonData['distance_km'];
        }
        return $data;
    }

    public function fetchGoogleApiData($address) {
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $url = $config->google_map->apiData . "?address=" . urlencode($address) . '&key=' . $config->google_map->key;
        $curl_handle = curl_init();
        curl_setopt($curl_handle, CURLOPT_URL, $url);
        curl_setopt($curl_handle, CURLOPT_CONNECTTIMEOUT, 10);
        curl_setopt($curl_handle, CURLOPT_RETURNTRANSFER, 1);
        $result = curl_exec($curl_handle);
        $result = curl_exec($curl_handle);
        if ($result === FALSE) {
            die('Curl failed: ' . curl_error($curl_handle));
        }
        curl_close($curl_handle);
        return $result;
    }

    public function fetchGoogleApiDistance($origin_lat, $origin_lng, $destiny_lat, $destiny_lng) {
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $url = $config->google_map->distUrl . "?origin=" . $origin_lat . ',' . $origin_lng . "&destination=" . $destiny_lat . ',' . $destiny_lng . "&key=" . $config->google_map->key;
        $curl_handle = curl_init();
        curl_setopt($curl_handle, CURLOPT_URL, $url);
        curl_setopt($curl_handle, CURLOPT_CONNECTTIMEOUT, 50);
        curl_setopt($curl_handle, CURLOPT_RETURNTRANSFER, 199130000);
        $result = curl_exec($curl_handle);
        $result = curl_exec($curl_handle);
        if ($result === FALSE) {
            die('Curl failed: ' . curl_error($curl_handle));
        }
        curl_close($curl_handle);
        return $result;
    }

    public function getDaysArray() {
        $data = ['1' => 'SU', '2' => 'M', '3' => 'T', '4' => 'W', '5' => 'TH', '6' => 'F', '7' => 'SA'];
        return $data;
    }

    public function insertContactDetails($data) {
        $url = $this->apiUrl() . "/contact";
        $resp = $this->post($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }

    public function insertOtp($data) {
        $url = $this->apiUrl() . "/activation";
        $resp = $this->post($url, $data);
        $response = Json::decode($resp->getBody(), true);
        return $response;
    }

    public function fetchOtp($data) {
        $user_id = $data['user_id'];
        $otp = $data['confirm_otp'];
        $val = '{"where":{"and": [{"UID": "' . $user_id . '"},{"Verification_code": "' . $otp . '"},{"isUsed": 0}]}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/activation?&filter=" . $val;
        $resp = $this->get($url);
        $response = Json::decode($resp->getBody(), true);
        return $response;
    }

    public function updateOtp($data) {
        $url = $this->apiUrl() . "/activation";
        $resp = $this->put($url, $data);
        $response = Json::decode($resp->getBody(), true);
        //Debug::dump($response);
        //exit;
        return $response;
    }

    public function cancelBooking($data) {
        $url = $this->apiUrl() . "/Booking/cancelBooking";
        $resp = $this->post($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }


    public function getPackage() {
        $packageType = [];
        $url = $this->apiUrl() . "/package-type";
        $val = $this->get($url);
        $jsonData = $val->getBody();
        $jsonResponse = Json::decode($jsonData, true);
        if (count($jsonResponse) > 0) {
            foreach ($jsonResponse as $key => $value) {
                $packageType [$value['tour_type']] = $value['tour_type'];
            }
        }

        return $packageType;
    }

    public function getBudget() {
        $budget = [];
        $url = $this->apiUrl() . "/master-budget";
        $val = $this->get($url);
        $jsonData = $val->getBody();
        $jsonResponse = Json::decode($jsonData, true);
        if (count($jsonResponse) > 0) {
            foreach ($jsonResponse as $key => $value) {
                $budget [$value['name']] = $value['name'];
            }
        }
        return $budget;
    }

    public function getVehicleType() {
        $vehicleType = [];
        $url = $this->apiUrl() . "/vehicle-type";
        $val = $this->get($url);
        $jsonData = $val->getBody();
        $jsonResponse = Json::decode($jsonData, true);
        if (count($jsonResponse['data']) > 0) {
            foreach ($jsonResponse['data'] as $key => $value) {
                $vehicleType [$value['vehicle_type']] = $value['vehicle_type'];
            }
        }
        return $vehicleType;
    }

    public function getJobsDataByPostId($id) {
        $val = '{"where":{"id": "' . $id . '"}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/department-jobs?&filter=" . $val;
        $resp = $this->get($url);
        $response = Json::decode($resp->getBody(), true);
        $response = $response['data'][0];
        return $response;
    }

    public function checkChangeTravelDateStatus($data) {
        if (($data['booking_status'] == 1) && ($data['current_date'] == $data['order_date'])) {
            if ($data['current_time'] <= $data['result_time']) {
                $status = "true";
            } else {
                $status = "false";
            }
        } else if (($data['booking_status'] == 1) && ($data['current_date'] < $data['order_date'])) {
            $status = "true";
        } else {
            $status = "false";
        }
        return $status;
    }
    
      /** Add Recent Viewed Items */
    public function addRecentViewedItems($data) {
        //echo '<pre>';print_r($data);die();
        $url = $this->apiUrl() . "/recently-viewed/addrecentlyvieweddata";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $JsonData = Json::decode($JsonData, true);
    }
    
      /** Delete Recent Viewed Items */
    public function deleteRecentViewedItems($data) {
        //echo '<pre>';print_r($data);die();
        $url = $this->apiUrl() . "/recently-viewed/deleterecentlyvieweddata";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $JsonData = Json::decode($JsonData, true);
    }
    
    
     /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 19-June-2022
     * @description : FUNCTION TO GET THE USER MARKUP STARTS HERE
     * @param $data
     * @returns $responsedata
     */
    
    public function getUserMarkupData($paramdata) {
        $data = [];
        $url = $this->apiUrl() . "/markup/getUserMarkupDetails";
        $val = $this->post($url, $paramdata);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
         if($responsedata['responsedata']['status']=="success"){
            $data = $responsedata['responsedata']['data'][0];
        }
        return $data;
    }

}
