<?php

namespace Application\Form;

use Zend\Form\Form;
use Zend\Form\Element\{Checkbox, Text, Submit, Hidden, Textarea};
use Zend\Validator\{Digits, EmailAddress, NotEmpty, StringLength};
use Zend\InputFilter\InputFilterProviderInterface;

class TicketForm extends Form implements InputFilterProviderInterface {

    public function __construct($name = null) {

        parent::__construct('ticket-form');

        /**
         * Name
         */
        $this->add([
            'name' => 'booking_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'booking-no',
                'placeholder' => 'Ticket No',
                'class' => 'form-control',
                'onkeypress' => "return isAlphaNumber(event)",
                'maxlength' => 35
            ],
            'options' => [
                'label' => 'Booking No.<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);



        /**
         * Mobile No
         */
        $this->add([
            'name' => 'mobile_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'mobile-no',
                'placeholder' => 'Mobile No.',
                'class' => 'form-control',
                'maxlength' =>10,
                'onkeypress'=>'return isNumber(event)'
            ],
            'options' => [
                'label' => 'Mobile No.<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        $this->add([
            'name' => 'ticket_type',
            'type' => Hidden::class,
        ]);



        /**
         * Submit
         */
        $this->add([
            'name' => 'ticket_submit',
            'type' => Submit::class,
            'attributes' => [
            'value' => 'Submit',
                'id' => 'ticket-submit',
                'class' => 'btn btn-primary',
                'onclick' => "submitForm('#ticket-form', event);"
            ],
        ]);

    }

    public function getInputFilterSpecification() {
        return [
            'booking_no' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Booking No'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'mobile_no' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Mobile No.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'Digits',
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please enter Numeric value only',
                            ],
                        ],
                        'break_chain_on_failure' => true,
                    ],
                    ['name' => 'StringLength',
                        'options' => [
                            'min' => 10,
                            'max' => 10,
                            'messages' => [
                                StringLength::TOO_LONG => 'Please enter Less than 10 Digits',
                                StringLength::TOO_SHORT => 'Please enter greater than 9 Digits',
                            ],
                        ],
                        'break_chain_on_failure' => true
                    ],
                ]
            ]
        ];
    }

}
