<?php

namespace Application\Form;

use Zend\Form\Form;
use Zend\Form\Element\{Checkbox, Text, Submit, Hidden, Textarea,Select,Number};
use Zend\Validator\{Digits, EmailAddress, NotEmpty, StringLength};
use Zend\InputFilter\InputFilterProviderInterface;

class JobEnquiryForm extends Form implements InputFilterProviderInterface {

    public function __construct($name = null) {

        parent::__construct('job-enquiry-form');

        /**
         * Name
         */
        $this->add([
            'name' => 'customer_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'customer-name',
                'class' => 'inputMaterial',
                'onkeypress' => "return isAlphaNumber(event)",
                'maxlength' => 35
            ],
            'options' => [
                'label' => 'Name <span style="color: red">*</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Email ID
         */
        $this->add([
            'name' => 'customer_email',
            'type' => Text::class,
            'attributes' => [
                'id' => 'customer-email',
                'class' => 'inputMaterial'
            ],
            'options' => [
                'label' => 'Email ID<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

         /**
         * Package Name
         */
        $this->add([
            'name' => 'experience',
            'type' => Text::class,
            'attributes' => [
                'id' => 'experience',
                'class' => 'inputMaterial',
                'maxlength'=>2,
                'onkeypress' => "return isNumber(event)",
            ],
            'options' => [
                'label' => 'Experience <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
            ],
        ]);

        /**
         * Email ID
         */
        $this->add([
            'name' => 'description',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'description',
                'class' => 'inputMaterial'
            ],
            'options' => [
                'label' => 'Description<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         * Mobile No
         */
        $this->add([
            'name' => 'customer_mobile',
            'type' => Text::class,
            'attributes' => [
                'id' => 'customer-mobile',
                'class' => 'inputMaterial',
                'onkeypress' => "return isNumber(event)",
                'maxlength' => 10
            ],
            'options' => [
                'label' => 'Mobile No<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);



        $this->add([
            'name' => 'post_name',
            'type' => Hidden::class,
        ]);

        /**
         * Submit
         */
        $this->add([
            'name' => 'enquiry_submit',
            'type' => Submit::class,
            'attributes' => [
            'value' => 'submit',
                'id' => 'enquiry-submit',
                'class' => 'btn btn-primary',
                'onclick' => "submitForm('#job-enquiry-form', event);"
            ],
        ]);

    }

    public function getInputFilterSpecification() {
        return [
            'customer_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'customer_mobile' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Mobile No.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'Digits',
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please enter Numeric value only',
                            ],
                        ],
                        'break_chain_on_failure' => true,
                    ],
                    ['name' => 'StringLength',
                        'options' => [
                            'min' => 10,
                            'max' => 10,
                            'messages' => [
                                StringLength::TOO_LONG => 'Please enter Less than 10 Digits',
                                StringLength::TOO_SHORT => 'Please enter greater than 9 Digits',
                            ],
                        ],
                        'break_chain_on_failure' => true
                    ],
                ]
            ],

            'customer_email' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Email Id',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'EmailAddress',
                        'options' => [
                            'messages' => [
                                EmailAddress::INVALID => 'Please enter Valid Email Id',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],

            'experience' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Experience'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],

            'description' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Description'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],

        ];
    }

}
