<?php

namespace Application;

use Zend\Router\Http\Literal;
use Zend\Router\Http\Segment;
use Zend\ServiceManager\Factory\InvokableFactory;

return [
    'router' => [
        'routes' => [
            'home' => [
                'type' => Literal::class,
                'options' => [
                    'route' => '/',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'index',
                    ],
                ],
            ],
            'application' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/dashboard[/:action]',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ],
                ],
            ],
            'static-pages' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/application/pages[/:page_name]',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'static-page'
                    ],
                    'constraints' => [
                        'page_name' => '[a-z-]+'
                    ],
                ],
            ],
            'fare-structure' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/application/fare-structure[/:booking_type]',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'fare-structure'
                    ],
                    'constraints' => [
                        'booking_type' => '[a-z-]+'
                    ],
                ],
            ],
            'cms-pages' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '[/:page-type/:page]',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'cms-pages'
                    ]
                ],
            ],
            'send-mail' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/application/sendMail',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'send-mail'
                    ],
                    'constraints' => [
                        'booking_type' => '[a-z-]+'
                    ],
                ],
            ],
            'send-sms' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/application/sendSms',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'send-sms'
                    ],
                    'constraints' => [
                        'booking_type' => '[a-z-]+'
                    ],
                ],
            ],
            'get-service-type' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/application/get-service-type',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'get-service-type'
                    ],
                ],
            ],
            'get-services-type' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/application/get-services-type',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'get-services-type'
                    ],
                ],
            ],
            'get-city-list' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/application/get-city-list',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'get-city-list'
                    ],
                ],
            ],

            'get-origin-list' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/application/get-origin-list',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'get-to-city-list'
                    ],
                ],
            ],
            'email-invite' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/application/email-invite',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'email-invite'
                    ],
                ],
            ],
            'mobile-invite' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/application/mobile-invite',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'mobile-invite'
                    ],
                ],
            ],
            'generate-ticket' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/application/generate-ticket',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'generate-ticket'
                    ],
                ],
            ],
            'holiday-enquiry' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/application/holiday-enquiry',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'holiday-enquiry'
                    ],
                ],
            ],

            'offer-enquiry' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/application/offer-enquiry',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'offer-enquiry'
                    ],
                ],
            ],

            'submit-ticket' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/application/submit-ticket',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'submit-ticket'
                    ],
                ],
            ],

            'confirm-ticket-otp' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/application/confirm-ticket-otp',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'confirm-ticket-otp'
                    ],
                ],
            ],

            'ticket-detail' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/application/ticket-detail',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'ticket-detail'
                    ],
                ],
            ],

            'ticket-sms' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/application/ticket-sms',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'ticket-sms'
                    ],
                ],
            ],

            'ticket-mail' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/application/ticket-mail',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'ticket-mail'
                    ],
                ],
            ],

            'ticket-cancel' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/application/ticket-cancel',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'ticket-cancel'
                    ],
                ],
            ],

            'change-travel-date' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/application/change-travel-date',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'change-travel-date'
                    ],
                ],
            ],

            'give-feedback' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/application/give-feedback',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'give-feedback'
                    ],
                ],
            ],

            'submit-feedback' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/application/submit-feedback',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'submit-feedback'
                    ],
                ],
            ],

            'terms-condition' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/application/terms-condition',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'terms-condition'
                    ],
                ],
            ],

            'refer-earn' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/refer-earn',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'refer-earn'
                    ],
                ],
            ],
            'offers' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/offers',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'offers'
                    ],
                ],
            ],
            'relationship-manager' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/relationship-manager',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'relationship-manager'
                    ],
                ],
            ],

            'reset-password' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/application/reset-password',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'reset-password'

                    ],
                ],
            ],

            'submit-enquiry' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/application/submit-enquiry',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'submit-enquiry'

                    ],
                ],
            ],

            'jd-details' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/application/jd-details',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'jd-details'
                    ],
                ],
            ],

            'job-enquiry' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/application/job-enquiry',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'job-enquiry'
                    ],
                ],
            ],

            'submit-job-enquiry' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/application/submit-job-enquiry',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'submit-job-enquiry'
                    ],
                ],
            ],

            'one-way-search' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/application/one-way-search',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'one-way-search'
                    ],
                ],
            ],
            
            'remove-recently-viewed' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/application/remove-recently-viewed',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'remove-recently-viewed'
                    ],
                ],
            ],
            'partner' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/partner',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'partner'
                    ],
                ],
            ],
        ],
    ],
    'navigation' => [
        'default' => [
            [
                'class'=> '<i class="fa fa-home"></i>',
                'label' => 'Home',
                'route' => 'home',
            ],
            [
                'label' => 'Local Hire',
                'route' => 'local-hire',
            ],
            [
                'label' => 'Point to Point',
                'route' => 'point-to-point',
            ],
            [
                'label' => 'Transfer',
                'route' => 'airport-transfer',
            ],
            [
                'label' => 'Outstation',
                'route' => 'outstation',
            ],
            [
                'label' => 'Activity',
                'route' => 'sight-seeing',
            ],
            /*[
                'label' => 'Guide Booking',
                'route' => 'guide-booking',
            ],*/
            [
                'label' => 'Refer & Earn',
                'route' => 'refer-earn',
            ],
            [
                'label' => 'Offer',
                'route' => 'offers',
            ],
//          [
//              'label' => 'Blog',
//              'route' => 'guide',
//          ],
        ],
    ],
    'controllers' => [
        'factories' => [
            Controller\IndexController::class => InvokableFactory::class,
            Controller\RestAPIClientController::class => InvokableFactory::class,
        ],
    ],
    'view_manager' => [
        'display_not_found_reason' => true,
        'display_exceptions' => true,
        'doctype' => 'HTML5',
        'not_found_template' => 'error/404',
        'exception_template' => 'error/index',
        'template_map' => [
            //'layout/layout' => __DIR__ . '/../view/layout/layout.phtml',
            'application/index/index' => __DIR__ . '/../view/application/index/index.phtml',
            'error/404' => __DIR__ . '/../view/error/404.phtml',
            'error/index' => __DIR__ . '/../view/error/index.phtml',
            'flash-message' => __DIR__ . '/../view/partial/flash-messages.phtml',
        ],
        'template_path_stack' => [
            __DIR__ . '/../view',
        ],
        'strategies' => [
            'ViewJsonStrategy',
        ],
    ],
    'controller_plugins' => [
        'aliases' => [
            'config' => Controller\Plugin\Application::class,
        ],
        'factories' => [
            Controller\Plugin\Application::class => Controller\Plugin\Factory\ApplicationFactory::class,
        ],
    ],
    'moduleLayouts' => [
        'Application' => 'layout/application.phtml'
    ],
    'view_helpers' => [
        'factories' => [
            View\Helper\MyHelper::class => InvokableFactory::class,
            'currentRoute' => Factory\View\Helper\CurrentRouteFactory::class
        ],
        'aliases' => [
            'mainMenu' => View\Helper\MyHelper::class
        ],
    ],
];
